# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "db_remote_state_bucket" {
  description = "Nazwa kubełka S3 dla zdalnych informacji o stanie bazy danych"
  type        = string
}

variable "db_remote_state_key" {
  description = "Ścieżka dostępu do zdalnych informacji o stanie bazy danych w S3"
  type        = string
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "server_port" {
  description = "Numer portu używany przez serwer dla żądań HTTP"
  type        = number
  default     = 8080
}

variable "alb_name" {
  description = "Nazwa mechanizmu ALB"
  type        = string
  default     = "terraform-asg-example"
}

variable "instance_security_group_name" {
  description = "Nazwa grupy bezpieczeństwa dla egzemplarzy EC2"
  type        = string
  default     = "terraform-example-instance"
}

variable "alb_security_group_name" {
  description = "Nazwa grupy bezpieczeństwa dla mechanizmu ALB"
  type        = string
  default     = "terraform-example-alb"
}
